<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('notifications_queue', function (Blueprint $table) {
            $table->id();

            // Notification type & channel
            $table->string('type'); // e.g., 'claim_update', 'policy_renewal'
            $table->enum('channel', ['email', 'sms', 'push', 'in_app', 'whatsapp', 'telegram'])->default('email');

            // Recipient targeting
            $table->foreignId('customer_id')->nullable()->constrained('customers')->nullOnDelete();
            $table->foreignId('corporate_customer_id')->nullable()->constrained('corporate_customers')->nullOnDelete();
            $table->foreignId('user_id')->nullable()->constrained('users')->nullOnDelete();

            // Notification content
            $table->string('recipient')->nullable(); // email address or phone number
            $table->string('subject')->nullable(); // for email
            $table->text('message');               // main content

            // Scheduling & queueing
            $table->timestamp('scheduled_at')->nullable();   // for delayed sending
            $table->timestamp('sent_at')->nullable();
            $table->timestamp('failed_at')->nullable();
            $table->integer('retry_count')->default(0);
            $table->enum('priority', ['low', 'normal', 'high', 'critical'])->default('normal');

            // Status tracking
            $table->enum('status', ['pending', 'sent', 'failed', 'retrying'])->default('pending');
            $table->text('error_log')->nullable();

            // Relation to other modules (optional polymorphic)
            $table->nullableMorphs('notifiable'); // e.g., claim, policy, lead

            // Metadata
            $table->json('meta')->nullable(); // additional parameters

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('notifications_queue');
    }
};
